/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ThrowStatement
extends AstNode {
    private AstNode expression;

    public ThrowStatement() {
        this.type = 50;
    }

    public ThrowStatement(int pos) {
        super(pos);
        this.type = 50;
    }

    public ThrowStatement(int pos, int len) {
        super(pos, len);
        this.type = 50;
    }

    public ThrowStatement(AstNode expr2) {
        this.type = 50;
        this.setExpression(expr2);
    }

    public ThrowStatement(int pos, AstNode expr2) {
        super(pos, expr2.getLength());
        this.type = 50;
        this.setExpression(expr2);
    }

    public ThrowStatement(int pos, int len, AstNode expr2) {
        super(pos, len);
        this.type = 50;
        this.setExpression(expr2);
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public void setExpression(AstNode expression) {
        this.assertNotNull(expression);
        this.expression = expression;
        expression.setParent(this);
    }

    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("throw");
        sb.append(" ");
        sb.append(this.expression.toSource(0));
        sb.append(";\n");
        return sb.toString();
    }

    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            this.expression.visit(v);
        }
    }
}

